### Android ZPL SDK Manual

#### 1 SDK Load and Use

##### 1.1 Load

- Copy the JAR and AAR packages in the SDK to the app/libs folder

- Add the following code to the build.gradle in the app

  ```java
  android{
    sourceSets {
          main {
              jniLibs.srcDirs = ['libs']
          }
      }
    packagingOptions {
          pickFirst 'lib/x86/libc++_shared.so'
          pickFirst 'lib/x86_64/libc++_shared.so'
          pickFirst 'lib/armeabi-v7a/libc++_shared.so'
          pickFirst 'lib/arm64-v8a/libc++_shared.so'
      }
  }
  implementation fileTree(dir: "libs", include: ["*.jar","*.aar"])
  implementation 'com.github.barteksc:pdfium-android:1.9.0'//SDK required 
  implementation 'com.blankj:utilcode:1.30.7'//SDK required 
  ```



##### 1.2 Use

- The interfaces we use are in the ZPLPrinterHelper class.

  ```java
  ZPLPrinterHelper mZPL = ZPLPrinterHelper.getZPL(mContext)
  mContext：context object.
  ```

- **Initialize WiFi Timeout (Recommended)**

  After obtaining the ZPLPrinterHelper instance, it is recommended to immediately load the WiFi connection timeout from local settings:

  ```java
  ZPLPrinterHelper zplPrinterHelper = ZPLPrinterHelper.getZPL(this);
  // Get saved timeout from local storage like SharedPreferences, default 5000ms
  int savedTimeout = SPStaticUtils.getInt("wifi_timeout", 5000);
  zplPrinterHelper.setWifiConnectTimeOut(savedTimeout);
  ```

  **Note:**
  - The default WiFi connection timeout is 5000 milliseconds
  - It is recommended to read user-set timeout from local storage when the app starts
  - The minimum timeout is 1000 milliseconds
  - The timeout takes effect during WiFi connection and affects the connection waiting time

  

#### 2 SDK Connecting Method

##### 2.1 Bluetooth Connection	

- describe

  ```java
  int PortOpen(String portSetting)
  ```

- Parameter

  ```java
  portSetting：”Bluetooth,”+MAC（MAC: Bluetooth address）
  ```

- Return

  ```java
  0: connection success.  -1: connection failure.
  ```

  

##### 2.2 WIFI Connection	

- describe

  ```java
  int PortOpen(String portSetting)
  ```

- Parameter

  ```java
  portSetting：“WiFi,”+IP+”,”+PortNumber
  IP：Printer IP address.
  PortNumber：port. Default: 9100
  ```

- Return

  ```java
  0: connection success.  -1: connection failure.
  ```

  

##### 2.3 USB Connection	

- describe

  ```java
  int PortOpen(UsbDevice usbdevice)
  ```

- Parameter

  ```java
  usbdevice：UsbDevice object.
  ```

- Return

  ```java
  0: connection success.  -1: connection failure.
  ```

  

##### 2.4 Disconnect	

- describe

  ```java
  boolean PorClose()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  true：disconnect succeed，false：disconnect fail。
  ```

  

#### 3 SDK Print Command

##### 3.1 Label Start

- describe

  ```java
  int start()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.2 set Coordinates

- describe

  ```java
  int setXY(String x,String y)
  ```

- Parameter

  ```java
  X：x-axis.
  Y：y-axis.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

  

##### 3.3 Label End

- describe

  ```java
  int end()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.4 Field Data Start

- describe

  ```java
  int FD(String fd)
  ```

- Parameter

  ```java
  fd：Text.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.5 Field Data End

- describe

  ```java
  int FS()
  ```

- Parameter

  ```java
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.6 Print Width

- describe

  ```java
  int PW(String pw)
  ```

- Parameter

  ```java
  pw：width (in dots).
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.PW(“100”)
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.7 Direction and Justification

- describe

  ```java
  int FW(String rotate,String justification)
  ```

- Parameter

  ```
  rotate：rint direction, value is as below:
  	N = normal
  	R = rotated 90 degrees
  	I = inverted 180 degrees
  	B = bottom-up 270 degrees, read from bottom up
  Justification：ustification method, value is as below:
  	0 = left justification
  	1 = right justification
  	2 = auto justification (script dependent)
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.FW(“N”,”0”)
  mZPL.setXY(“0”,”0”);
  mZPL.FD(“TEXT”);
  mZPL.FS();
  mZPL.end();
  ```

  

##### 3.8 Print Line

- describe

  ```java
  int printLine(String w,String h,String t,String c,String r)
  ```

- Parameter

  ```
  w: width of line (1~32000 unit: dot)
  H: height of line (1~32000 unit: dot)
  T: thickness of line (1~32000 unit: dot)
  C: color of line:
  	B=black; (Default:B)
  	W=white；
  R: radian of rounded corner(0~8)
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printLine(“100”,”2”,”2”,”B”,”0”)//Print the horizontal line with 100-dot width and 2-dot height
  mZPL.end();
  ```

  

##### 3.9 Print Circle

- describe

  ```java
  int printCircle(String d,String t,String c)
  ```

- Parameter

  ```
  d: diameter of circle (3~4095).
  t: thickness of circle border (1~4095).
  C: color of circle:
  	B=black；(Default:B)
  	W=white；
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printCircle(“100”,”2”,”B”)
  mZPL.end();
  ```

  

##### 3.10 Print Slash Line

- describe

  ```java
  int printSlashLine(String w,String h,String t,String c,String o)
  ```

- Parameter

  ```
  w: width of slash line (3~32000).
  H: height of slash line (3~32000).
  T: thickness of slash line (1~32000).
  C: color of slash line:(Default:B)
  	B=black；
  	W=white；
  O：direction of slash line:(Default:R)
  	R (or /) = right-leaning diagonal
  	L (or \) = left-leaning diagonal
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.setXY(“0”,”0”);
  mZPL.printSlashLine(“100”,”100”,”2”,”B”,”R”)
  mZPL.end();
  ```

  

##### 3.11 Set  Label Home Position

- describe

  ```java
  int LH(String x,String y)
  ```

- Parameter

  ```
  X: x-axis of home position
  Y: y-axis of home position
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

  

##### 3.12 Label Shift

- describe

  ```java
  int LS(String ls)
  ```

- Parameter

  ```
  ls：shift value (-9999~9999) negative indicates right shift, (Default:0).
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.LS(“20”)
  mZPL.printText(“100”,”100”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.13 Text Blocks 

- describe:has an automatic word-wrap function

  ```java
  int TB(String a,String b,String c)
  ```

- Parameter

  ```
  a: block rotation:
    N = normal
    R = rotate 90 degrees clockwise
    I = invert 180 degrees
    B = read from bottom up-270 degrees
  b: block width in dots
  c: block height in dots
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.TB(“N”,”300”,”300”)
  mZPL.printText(“100”,”100”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.14 QR Code

- describe

  ```java
  int printQRcode(String x,String y,String orientation,
                  String magnification,String size,String data)
  ```

- Parameter

  ```
  x: x-axis
  y: y-axis
  orientation: (N).
  magnification:Default(2)
  	1= Normal mode
  	2= Enhanced mode
  size: size (1~10).
  data: content of 2D code
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n");
  mZPL.printQRcode(“10”,”10”,”N”,”2”,”5”,”abc123”);
  mZPL.end();
  ```

  

##### 3.15 Bar Code

- describe

  ```java
  int printBarcode(String x,String y,int type,String ratio,
                   String orientation,String height,String f,String data)
  ```

- Parameter

  ```
  x: x-axis
  y: y-axis
  type:
  	0=39
  	1=EAN-8
  	2=UPC-E
  	3=93
  	4=128
  	5=EAN-13
  ratio:Ratio of width and width of barcodes (1-3).
  Orientation:
    N = normal
    R = rotated 90 degrees (clockwise)
    I = inverted 180 degrees
    B = read from bottom up, 270 degrees
  Height: height of bar code (1-32000).
  F: whether the content of bar code is visible (Default Y):
    Y = yes
    N = no
  data: content of bar code
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printBarcode("10","10","0","2","N","100","Y","123456789");
  mZPL.end();
  ```

  

##### 3.16 Print Bitmap

- describe

  ```java
  void printBitmap(String x, String y, int halftoneType, Bitmap bmp)
  ```

- Parameter

  ```
  x: starting x-axis
  y: starting y-axis
  halftoneType：Image Algorithm
  	0：Binary (black and white)
  	1：jitter
  bmp：bitmap object.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printBitmap(“10”,”10”,0,bitmap);
  mZPL.end();
  ```

  

##### 3.17 Write Data

- describe

  ```java
  int WriteData(byte[] bData)
  ```

- Parameter

  ```
  bData: the data which needs to be sent to the printer
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.WriteData(byt)
  ```

  

##### 3.18 Read Data

- describe

  ```java
  byte[] ReadData(int outTime)
  ```

- Parameter

  ```
  outTime: time of outTime (Unit: second)
  ```

- Return

  ```java
  The read data
  ```

- Example

  ```java
  mZPL.ReadData(2)
  ```

  

##### 3.19 Self Test Page

- describe

  ```java
  int selfTest()
  ```

- Parameter

  ```
  null
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.selfTest()
  ```

  

##### 3.20 Print Text

- describe：You need to select a code when printing Chinese, please refer to the example.

  ```java
  int printText(String x,String y,int type,String orientation,int size,String data)
  ```

- Parameter

  ```
  x: x-coordinate
  y: y-coordinate
  type: font (0~6: ineffective for Chinese,7:Chinese)
  orientation：
    N = normal
    R = rotate 90 degrees clockwise
    I = invert 180 degrees
    B = read from bottom up-270 degrees
  size: font size
    1: 10px
    2: 20px
    3: 30px
    4: 40px
    5: 50px
    6: 60px
  data: text data
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")//This sentence needs to be added when printing Chinese
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.end();
  ```

  

##### 3.21 Print Quantity and Cutter

- describe：

  ```java
  int PQ(String q,String p,String r,String o)
  ```

- Parameter

  ```
  q:print quantity
  p:Number before suspension or before cutting knife
  r:Number of copies of each serial number
  o:Cut or pause
    Y:cutter
    N:pause
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.PQ(1,1,1,Y);//Print one piece and then cut the knife
  mZPL.end();
  ```

  

##### 3.22 Printer Model

- describe：

  ```java
  int setPrinterModel(String model)
  ```

- Parameter

  ```
  model：
  	T = Tear.
  	P = Peel （Not supported on some machines）.
  ```

- Return

  ```java
  Greater than 0:Normal, otherwise abnormal.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.printData("^CI14\r\n")
  mZPL.printText(“0”,”0”,5,”N”,3,”TEXT”);
  mZPL.setPrinterModel(“P”);//Switch to peel mode
  mZPL.end();
  ```

  

##### 3.23 Write RFID

- describe：

  ```java
  int writeRFID(int address, int memory,byte[] data)
  ```

- Parameter

  ```
  address：starting address
  	range: greater than 0 EPC address must start at 2.
  memory：write area
  	0 = Preserved
  	1 = EPC 
  	3 = User
  data：需写入的数据。（保留区，EPC不超过12个字节，User不超过128）
  ```

- Return

  ```java
  -1：send failed，-2：parameter error，0：write successful.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.writeRFID(0,1,"Test RFID".getBytes());
  mZPL.end();
  ```

  

##### 3.24 Read RFID

- describe：

  ```java
  byte[] readRFID(int address,int length,int memory)
  ```

- Parameter

  ```
  address：starting address.
  	range: greater than 0 EPC address must start at 2.
  length：The length of the read. Preserved\EPC no more than 12 bytes, User no 				more than 128
  memory：Write area 
  	0 = Preserved
  	1 = EPC 
  	3 = User
  ```

- Return

  ```java
  Readable data, empty means read failed.
  ```

- Example

  ```java
  mZPL.start();
  mZPL.writeRFID(2,1,"中文".getBytes("GB2312"));
  mZPL.readRFID(2, 4, 1);
  mZPL.end();
  byte[] bytes = mZPL.ReadData(3);
  if (bytes!=null&&bytes.length>0){
    String hexStr = new String(bytes);
    byte[] hexByte = UtilityTooth.hexToByte(hexStr);
  	Toast.makeText(thisCon,newString(hexByte,"GB2312"),Toast.LENGTH_SHORT).show();
  }
  ```

  

##### 3.25 Read SN

- describe：

  ```java
  String getPrinterSN()
  ```

- Parameter

  ```
  null
  ```

- Return

  ```java
  SERIAL NEMBER:SN.
  ```

- Example

  ```java
  mZPL.getPrinterSN();
  ```

  

##### 3.26 PDF to Bitmap

- describe：

  ```java
  List<Bitmap> pdfToBitmap(Context context, File file, String pageNumber, int pageWidth)
  ```

- Parameter

  ```
  context：context object.
  file：PDF file.
  pageNumber：page number（"1,3-7"）。
  pageWidth：bitmap width.
  ```

- Return

  ```java
  List<Bitmap>：bitmap.
  ```

- Example

  ```java
  List<Bitmap> bitmaps = mZPL.pdfToBitmap(thisCon, file, "1", 576);
  ```

  

##### 3.27 Print Height

- describe

	```java
	int setPrintHeight(String height)
	```

- Parameter

	```java
	height：height（unit：dots）
	```

- Return

	```java
	Greater than 0:Normal, otherwise abnormal.
	```

- Example

	```java
	mZPL.start();
	mZPL.setPrintHeight(“100”)
	mZPL.setXY(“0”,”0”);
	mZPL.FD(“TEXT”);
	mZPL.FS();
	mZPL.end();
	```

	

##### 3.28 Listen for print status

- describe

	```java
	void setPrintListener(PrintListener listener)
	```

- Parameter

	```java
	interface PrintListener {
	    fun onPrintStatus(phase: Phase)
	
	}
	data class Phase(
	    val taskID: String, 
	    val type: Type?, //Printing phase
	    val reasonList: List<Reason>, //Print error reason
	    val numIndex: Int, //The sequence number of the current print job in a multi-page print job
	    val numTotal: Int, //The number of pages of a multi-page print job
	    val copyIndex: Int, //Copy the task serial number
	    val copyTotal: Int//The total number of copy tasks
	)
	data class Type(
	    val code: Int, //See 4.1
	    val description: String//description
	)
	data class Reason(
	    val code: Int, //See 4.2
	    val description: String//description
	)
	```

- Return

	```java
	null
	```

- Example

	```java
	mZPL.setPrintListener(phase -> {
	            ToastUtils.showToast(thisCon, phase.toString());
	        });
	```




##### 3.29 Get printer wifi information

- describe

	```java
	public PrinterWifiConfig getPrinterWifiConfig()
	```

- Parameter

	```java
	null
	```

- Return

	```java
	public class PrinterWifiConfig {
	    private int model;//0：close，1：AP，2：STA
	    private ApWifiConfig apWifiConfig;//AP Parameters
	    private StaWifiConfig staWifiConfig;//STA Parameters
	}
	public class ApWifiConfig {
	    private boolean dhcpEnabled;//whether enable DHCP configure IP 
	    private String ipAddress;//IP address
	    private String ssid;//wifi name
	    private String password;//wifi password
	    private boolean isOpen;//password required (true: no password required, 
	  //false: password required)
	}
	public class StaWifiConfig {
	    private boolean dhcpEnabled;//whether enable DHCP configure IP 
	    private String encryptionType;//encryption（"OPEN","WEP","WPA2-PSK",
	  //"WPA/WPA2-PSK","WPA-PSK","WPA","WPA2","SAE","WPA3-WPA2-PSK-MIX","UNKNOW"）
	    private String ssid;//wifi name
	    private String password;//wifi password
	    private String ipAddress;//IP address
	    private String gateway;//gateway
	    private String netmask;//netmask
	}
	```

- Example

	```java
	PrinterWifiConfig printerWifiConfig = zplPrinterHelper.getPrinterWifiConfig();
	```



##### 3.30 Configure Wi-Fi  in AP mode

- describe

	```java
	public boolean configApWifi(ApWifiConfig apWifiConfig)
	```

- Parameter

	```java
	public class ApWifiConfig {
	    private boolean dhcpEnabled;//whether enable DHCP configure IP 
	    private String ipAddress;//IP address
	    private String ssid;//wifi name
	    private String password;//wifi password
	    private boolean isOpen;//password required (true: no password required, 
	  //false: password required)
	}
	```

- Return

	```java
	true：send succeed，false：send fail.
	```

- Example

	```java
	ApWifiConfig apWifiConfig = new ApWifiConfig();
	apWifiConfig.setSsid(ssid);
	boolean apPasswordCheck = apNeedPasswordCheckBox.isChecked();
	String apPassword = "";
	if (apPasswordCheck){
			apPassword = apPasswordEditText.getText().toString();
			apWifiConfig.setPassword(apPassword);
	}
	boolean apDhcpCheckBoxChecked = apDhcpCheckBox.isChecked();
	apWifiConfig.setDhcpEnabled(apDhcpCheckBoxChecked);
	String apIp = "";
	if (!apDhcpCheckBoxChecked){
			apIp = apIpEditText.getText().toString();
			apWifiConfig.setIpAddress(apIp);
	}
	zplPrinterHelper.configApWifi(apWifiConfig);
	```



##### 3.31 Configure Wi-Fi  in STA mode

- describe

	```java
	public boolean configStaWifi(StaWifiConfig staWifiConfig)
	```

- Parameter

	```java
	public class StaWifiConfig {
	    private boolean dhcpEnabled;//whether enable DHCP configure IP 
	    private String encryptionType;//encryption（"OPEN","WEP","WPA2-PSK",
	  //"WPA/WPA2-PSK","WPA-PSK","WPA","WPA2","SAE","WPA3-WPA2-PSK-MIX","UNKNOW"）
	    private String ssid;//wifi name
	    private String password;//wifi password
	    private String ipAddress;//IP address
	    private String gateway;//gateway
	    private String netmask;//netmask
	}
	```

- Return

	```java
	true：send succeed，false：send fail.
	```

- Example

	```java
	StaWifiConfig staWifiConfig = new StaWifiConfig();
	staWifiConfig.setSsid(ssid);
	String encryption = (String)encryptionSpinner.getSelectedItem();
	staWifiConfig.setEncryptionType(encryption);
	String staPassword = staPasswordEditText.getText().toString();
	staWifiConfig.setPassword(staPassword);
	boolean staDhcpChecked = staDhcpCheckBox.isChecked();
	staWifiConfig.setDhcpEnabled(staDhcpChecked);
	if (!staDhcpChecked){
			String staIp = staIpEditText.getText().toString();
			staWifiConfig.setIpAddress(staIp);
			String staGateway = staGatewayEditText.getText().toString();
			staWifiConfig.setGateway(staGateway);
			String staNetmask = staNetmaskEditText.getText().toString();
			staWifiConfig.setNetmask(staNetmask);
	}
	zplPrinterHelper.configStaWifi(staWifiConfig);
	```



##### 3.32 Set WiFi Connection Timeout

- describe

	```java
	public void setWifiConnectTimeOut(int wifiConnectTimeOut)
	```

- Parameter

	```java
	wifiConnectTimeOut: WiFi connection timeout in milliseconds (minimum 1000ms, default 5000ms)
	```

- Return

	```java
	null
	```

- Example

	```java
	// Set WiFi connection timeout to 8000 milliseconds
	zplPrinterHelper.setWifiConnectTimeOut(8000);
	```



##### 3.33 Get WiFi Connection Timeout

- describe

	```java
	public int getWifiConnectTimeOut()
	```

- Parameter

	```java
	null
	```

- Return

	```java
	int: Current WiFi connection timeout in milliseconds
	```

- Example

	```java
	// Get current WiFi connection timeout
	int currentTimeout = zplPrinterHelper.getWifiConnectTimeOut();
	Log.d("WiFiTimeout", "Current timeout: " + currentTimeout + "ms");
	```



##### 3.34 Get Firmware Version

- describe

	```java
	public void getFirmwareVersion(FirmwareVersionListener listener)
	```

- Parameter

	```java
	public interface FirmwareVersionListener {
	    void onFirmwareVersion(String firmwareVersion, String betaVersion);
	}
	```

- Return

	```java
	null
	```

- Example

	```java
	zplPrinterHelper.getFirmwareVersion((version, betaVersion) -> {
	    runOnUiThread(() -> {
	        AlertDialog.Builder builder = new AlertDialog.Builder(Activity_Main.this);
	        builder.setTitle(getString(R.string.firmware_version_info));
	        builder.setMessage("Main Version: " + version + "\nBeta Version: " + betaVersion);
	        builder.setPositiveButton(getString(R.string.sure), null);
	        builder.show();
	    });
	});
	```



##### 3.35 Get Printer Status

- describe

	```java
	public void getPrinterStatus(ZPLPrinterStatusListener listener)
	```

- Parameter

	```java
	public interface ZPLPrinterStatusListener {
	    void onStatus(int status);
	  	//status:(0: Normal, 1: Open cover, 2: Lack of paper, 3: Overheated, 
	  	//				4: Printing, 5: Lack of ribbon)
	}
	```

- Return

	```java
	null
	```

- Example

	```java
	zplPrinterHelper.getPrinterStatus(status -> {
	                switch (status) {
	                    case ZPLPrinterHelper.STATUS_OK:
	                        mStatusStr = getString(R.string.status_ok);
	                        break;
	                    case ZPLPrinterHelper.STATUS_COVER_OPENED:
	                        mStatusStr = getString(R.string.status_cover_opened);
	                        break;
	                    case ZPLPrinterHelper.STATUS_NOPAPER:
	                        mStatusStr = getString(R.string.status_nopaper);
	                        break;
	                    case ZPLPrinterHelper.STATUS_OVER_HEATING:
	                        mStatusStr = getString(R.string.status_over_heating);
	                        break;
	                    case ZPLPrinterHelper.STATUS_PRINTING:
	                        mStatusStr = getString(R.string.status_printing);
	                        break;
	                    case ZPLPrinterHelper.STATUS_NORIBBONS:
	                        mStatusStr = getString(R.string.status_noribbons);
	                        break;
	                    default:
	                        break;
	                }
	                runOnUiThread(() -> Toast.makeText(thisCon, mStatusStr, Toast.LENGTH_SHORT).show());
	            });
	```



##### 3.36 **Leak-proof function** 

- describe（1）

	This function can be used to prevent the printer from missing typing, then set the task ID, send the print data, and finally get the print result. (Universal interface)

	```java
	//Turn on the anti-leakage function
	public boolean setMissedHitsSwitch(boolean isOpen)
	```

	```java
	//Set the print ID (1-9999) 
	//(the beginning and end need to be set, and the ID must be increased sequentially)
	public boolean setMissedHitsID(int id)
	```

	```java
	//Listen to the print results
	public void setMissedHitsTaskListener(MissedHitsTaskListener listener)
	```

- Parameter

	```java
	public interface MissedHitsTaskListener {
	    void onResult(int id, int result);
	}
	//id: task ID, result: task result (data by bit)
	if (result == 0){
	    resultStr = getString(R.string.print_normal);//print succeed
	}else{
	    if ((result & 2) == 2) {
	         resultStr += getString(R.string.status_cover_opened);//cover opened
	    } else if ((result & 8) == 8) {
	         resultStr += getString(R.string.status_nopaper);//no paper
	    } else if ((result & 16) == 16) {
	         resultStr += getString(R.string.status_printing);//printing
	    } else if ((result & 32) == 32) {
	         resultStr += getString(R.string.status_over_heating);//over heating
	    } else if ((result & 64) == 64) {
	         resultStr += getString(R.string.status_form_error);//form error
	    }else{
	         resultStr += getString(R.string.status_other_error);//other error
	    }
	 }
	```

- Return

	```java
	null
	```

- Example

	```java
	zplPrinterHelper.setMissedHitsTaskListener((id, result) -> {
	            String resultStr = "ID:" + id;
	            if (result == 0) {
	                resultStr += getString(R.string.print_normal);
	            } else {
	                if ((result & 2) == 2) {
	                    resultStr += getString(R.string.status_cover_opened);
	                } else if ((result & 8) == 8) {
	                    resultStr += getString(R.string.status_nopaper);
	                } else if ((result & 16) == 16) {
	                    resultStr += getString(R.string.status_printing);
	                } else if ((result & 32) == 32) {
	                    resultStr += getString(R.string.status_over_heating);
	                } else if ((result & 64) == 64) {
	                    resultStr += getString(R.string.status_form_error);
	                }else{
	                    resultStr += getString(R.string.status_form_error);
	                }
	            }
	            String finalResultStr = resultStr;
	            runOnUiThread(() -> Toast.makeText(thisCon, finalResultStr, Toast.LENGTH_SHORT).show());
	        });
	zplPrinterHelper.setMissedHitsSwitch(true);
	zplPrinterHelper.setMissedHitsID(1);
	printSampleReceipt();
	zplPrinterHelper.setMissedHitsID(1);
	```



- describe（2）

	This function can be used to prevent the printer from missing typing, then set the task ID, send the print data, and finally get the print result. (Some printers support)

	```java
	//Set Print ID (0-65535)
	public boolean setTaskID(int id)
	```

	```java
	//Listen to the print results
	public void setPrintResultListener(PrintResultListener listener)
	```

- Parameter

	```java
	public interface PrintResultListener {
	    void onResult(int id, int result);
	}
	//id: task ID, result: task result (data by bit)
	if (result == 0){
	    resultStr = getString(R.string.print_normal);//Print successfully
	}else{
	    if((result & 1) == 1){
	      resultStr = getString(R.string.status_nopaper);//Printing failure (out of paper)
	    }else if((result & 2) == 2){
	      resultStr = getString(R.string.status_cover_opened);//Print failure (cap opening)
	    }
	 }
	```

- Return

	```java
	null
	```

- Example

	```java
	zplPrinterHelper.setPrintResultListener((id, result) -> {
	            String resultStr = "";
	            if (result == 0){
	                resultStr = getString(R.string.print_normal);
	            }else{
	                if((result & 1) == 1){
	                    resultStr = getString(R.string.status_nopaper);
	                }else if((result & 2) == 2){
	                    resultStr = getString(R.string.status_cover_opened);
	                }
	            }
	            String finalResultStr = resultStr;
	            runOnUiThread(() -> Toast.makeText(thisCon, finalResultStr, Toast.LENGTH_SHORT).show());
	        });
	zplPrinterHelper.setTaskID(1);
	printSampleReceipt();
	```



##### 4.1 Printing phase

 

| key   | value                                              |
| ----- | -------------------------------------------------- |
| 01001 | Start printing                                     |
| 01002 | After the printing is completed, carry the task ID |
| 01003 | Failed to print, carrying task ID                  |
| 01004 | Pause with the task ID                             |
| 01010 | Cancel the print                                   |
| 01011 | The exception causes the print to be canceled      |
| 01012 | button to cancel printing                          |
| 01013 | The app cancels the print                          |
| 01020 | Print cyan                                         |
| 01021 | Print red                                          |
| 01022 | Print yellow                                       |
| 01023 | Print black                                        |
| 01024 | Attached film                                      |



##### 4.2Printer status error code

| 值    | description                                                  |
| ----- | ------------------------------------------------------------ |
| 11001 | Paperless                                                    |
| 11002 | The paper reader failed to roll the paper into the paper lane |
| 11003 | high temperature                                             |
| 11004 | The back cover opens                                         |
| 11005 | Warm-up failed                                               |
| 12001 | Stuck on the paper output side                               |
| 12002 | Stuck in the print channel                                   |
| 12003 | Stuck in the rear ejection channel                           |
| 12004 | Stuck in the duplex print carousel area                      |
| 13001 | Illegal consumables                                          |
| 13002 | There is no toner cartridge                                  |
| 13003 | No toner                                                     |
| 13004 | No black cartridges were detected                            |
| 13005 | Color cartridges were not detected                           |
| 13006 | Black cartridges are not available                           |
| 13007 | Color cartridges are not available                           |
| 13008 | The black cartridge ran out                                  |
| 13009 | Color cartridges run out                                     |
| 14001 | The paper scrubbing equipment is abnormal                    |
| 14002 | The paper feeding device is abnormal                         |
| 14003 | Inkjet printheads are in abnormal contact                    |
| 14004 | The ink cart moves abnormally                                |
| 14005 | The ink cart moves abnormally artificially                   |